package com.example.controller;

import com.example.entity.Book;
import com.example.entity.Record;
import com.example.service.RecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/record")
public class RecordController {
    @Autowired
    private RecordService recordService;

    @RequestMapping(value = "/insert")
    public List<Record> insert(Record record){
        recordService.insert(record);
        return recordService.selectAll();
    }

    @RequestMapping("/returnBook")
    public Record returnBook(int recordId){
        return recordService.returnBook(recordId);
    }

    @RequestMapping("/selectById")
    public  Record selectById(int recordId){
      return   recordService.selectById(recordId);
    }

    @RequestMapping("/selectAll")
    public  List<Record> selectAll(){
        return recordService.selectAll();
    }







}
