package com.example.controller;

import com.example.entity.User;
import com.example.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/user")
public class UserController {
    @Autowired
    private UserService userService;

    @RequestMapping(value = "/selectById")
    public User select(int userId){
        return userService.selectById(userId);
    }

    @RequestMapping(value = "/selectAll")
    public List<User> selectAll(){
        return userService.selectAll();
    }

    @RequestMapping(value = "/insert")
    public List<User> insert(User user){
        userService.insert(user);
        return userService.selectAll();
    }

    @RequestMapping(value = "/delete")
    public List<User> delete(int userID){
        userService.delete(userID);
        return userService.selectAll();
    }


    @RequestMapping(value = "/update")
    public List<User> update(User user){
        userService.update(user.getUserId(),user);
        return userService.selectAll();
    }





}
