package com.example.dao;

import com.example.entity.User;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;
import java.util.List;

/**
 * 描述：书籍相关操作服务层
 * @author Yangxue
 * @version V1.0
 * @class DaoMapper
 * @packageName com.example.dao
 * @description 提供用户的增删改查接口
 * @data 2020/4/13
 **/

@Repository
@Mapper
public interface UserMapper {
    @Insert("insert into user(name,age)values(#{name},#{age})")
    int insert(User user);

    @Update("update user set name=#{user.name},age=#{user.age} where userId =#{userId}")
    int update(int userId,User user);

    @Delete("delete from user where userId =#{userId}")
    int  delete(int userId);

    @Select("select * from user where userId =#{userId} ")
    User selectById(int userId);

    @Select("select userId,name, age from user")
    List<User> selectAll();
}
