package com.example.dao;

import com.example.entity.Book;
import org.apache.ibatis.annotations.*;
import java.util.List;

@Mapper
public interface DaoMapper {

//    新增一个book
    @Insert("insert into book(name,author,price,num)values(#{name},#{author},#{price},#{num})")
    int insert(Book book);

    //    删除一个book
    @Delete("delete from book where id = #{id}")
    int delete(Integer id);

    //    更改一个book
    @Update("update book set name=#{book.name},author=#{book.author},price=#{book.price},num=#{book.num} where id =#{id}")
    int update(Integer id,Book book);

    //    查询一个book
    @Select("select id,name,author,price,num from book where id=#{id}")
    Book selectById(Integer id);

    //    查询全部book
    @Select("select id,name,author,price,num from book")
    List<Book> selectAll();



}






