package com.example.service;

import com.example.dao.DaoMapper;
import com.example.entity.Book;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BookServiceImpl implements BookService {
    @Autowired
    private DaoMapper daoMapper;

    @Override
    public int insert(Book book) {
        return daoMapper.insert(book);
    }

    @Override
    public int delete(Integer id) {
        return daoMapper.delete(id);
    }

    @Override
    public int update(Integer id, Book book) {
        return daoMapper.update(id,book);
    }

    @Override
    public Book selectById(Integer id) {
        return daoMapper.selectById(id);
    }

    @Override
    public List<Book> selectAll() {
        return daoMapper.selectAll();
    }
}
