package multithread;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author 杨雪
 */
public class SnowFake {
    /**
     * 开始时间截（这个可以自己使用已经流逝的时间，我用的是自己写代码时的实际时间)
     */
    private static final long START_STAMP = 1590368867576L;

    /**
     * 数据中心在id中占的位数
     */
    private static final long DATA_CENTER_ID = 5L;

    /**
     * 机器码在id中占的位数
     */
    private static final long MACHINE_ID = 1L;

    /**
     * 序列号在id中占得位数
     */
    private static final long SERIAL_NUMBER = 16L;

    /**
     * 序列号最大值4095
     */
    private static final long MAX_SERIAL_NUMBER = -1L ^ -1L << SERIAL_NUMBER;

    private long dataCenter = 0L;

    private long machineId = 0L;

    private long serialNumber = 0L;
    /**
     * 上次生成ID的时间截
     */
    private long lastTimestamp = 0L;

    /**
     * 数据标识id向左移17位(12+5)
     */
    private final long datacenterIdLeft = SERIAL_NUMBER + MACHINE_ID;
    /**
     * 时间截向左移22位(5+5+12)
     */
    private final long timestampLeftShift = SERIAL_NUMBER + MACHINE_ID + DATA_CENTER_ID;

    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public synchronized long newId() {
        long currentTimestamp = getCurrentTimestamp();
        if (currentTimestamp < lastTimestamp) {
            throw new RuntimeException(
                    "出现时钟回拨异常");
        }
        if (currentTimestamp == lastTimestamp) {

            serialNumber = (serialNumber + 1) & MAX_SERIAL_NUMBER;

            if (serialNumber == 0L) {

                while (lastTimestamp >= currentTimestamp) {
                    currentTimestamp = getCurrentTimestamp();
                }
            }
        } else {
            currentTimestamp = getCurrentTimestamp();
            serialNumber = 0L;
        }
        lastTimestamp = currentTimestamp;
        long l = ((currentTimestamp - START_STAMP) << timestampLeftShift)
                | dataCenter << datacenterIdLeft
                | (machineId << SERIAL_NUMBER)
                | serialNumber;
        return l;
    }

}


