package com.tykj.classified.config.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.HttpHeaders;
import com.google.gson.JsonObject;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.entity.vo.UserVo;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.utils.info.CipherUtil;
import com.tykj.classified.utils.info.JwtKeys;
import com.tykj.classified.utils.info.JwtUtil;
import com.tykj.classified.utils.string.StringUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhaolu
 * @create 2022-08-23 20:00
 */

@Component
public class BaseInterceptor implements HandlerInterceptor {
    private Logger log = LoggerFactory.getLogger(BaseInterceptor.class);

    private JwtKeys keys;

    public BaseInterceptor(JwtKeys keys) {
        this.keys = keys;
    }

//    /**
//     * 请求处理前
//     * @param request 请求头
//     * @param response 响应
//     * @param handler 适配器
//     * @return boolean
//     */
//    @Override
//    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
//        // 获取请求头中的 单位编号 信息
//        String token = request.getHeader("token");
//        String currentUnitId = request.getHeader("currentUnitId");
//        if (!org.apache.commons.lang3.StringUtils.isBlank(token)&&!request.getRequestURI().equals("/newUser/login")) {
//            //解析token
//            String encode = URLDecoder.decode(token,"utf-8");
//            token = encode.replaceAll(" ","+");
//            String decrypt = CipherUtil.decrypt(token, CipherUtil.string2PrivateKey(keys.getRsaPrivateKey()));
//            Jws<Claims> claimsJws;
//            try {
//                claimsJws =
//                        JwtUtil.parseClaimsJws(decrypt, keys.getJwtPublicKey());
//            }catch (ExpiredJwtException e){
//                e.printStackTrace();
//                throw new BizException("Token解析失败");
//            }
//
//            List list1 = claimsJws.getBody().get("roleStrings", List.class);
//            if(!list1.contains("ROLE_DMRY1")) {
//                throw new BizException("401","权限不足");
//            }
//
//            //判断token是否被顶替
//            UserVo userVo = new UserVo();
//            userVo.setId(claimsJws.getBody().get("id", String.class));
//            userVo.setUserName(claimsJws.getBody().get("username", String.class));
//            if (StringUtils.isNotEmpty(currentUnitId)) { // 切换单位
//                userVo.setUnitId(claimsJws.getBody().get("specificationCode", String.class));
//                userVo.setUnitName(claimsJws.getBody().get("organizationName",String.class));
//                userVo.setUnitIdTwo(currentUnitId);
//                userVo.setUnitNameTwo(URLDecoder.decode(request.getHeader("currentUnitName"),"UTF-8"));
//            } else {// 如果没有切换单位,存当前单位到现单位中
//                userVo.setUnitId(claimsJws.getBody().get("specificationCode", String.class));
//                userVo.setUnitName(claimsJws.getBody().get("organizationName",String.class));
//                userVo.setUnitIdTwo(claimsJws.getBody().get("specificationCode", String.class));
//                userVo.setUnitNameTwo(claimsJws.getBody().get("organizationName",String.class));
//            }
//            userVo.setClassification(claimsJws.getBody().get("classification", Integer.class));
//            MyThreadLocal.set(userVo);
//        }
//        return true;
//    }

    /**
     * 请求处理前
     *
     * @param request  请求头
     * @param response 响应
     * @param handler  适配器
     * @return boolean
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        // 获取请求头中的 切换单位 信息
        String currentUnitId = request.getHeader("currentUnitId");
        //判断token是否被顶替
        UserVo userVo = new UserVo();
        userVo.setId("1");
        userVo.setUserName("admin");
        if (StringUtils.isNotEmpty(currentUnitId)) {
//            userVo.setUnitId("11330100002489006R");
//            userVo.setUnitName("市本级保密局");
//            userVo.setUnitIdTwo(currentUnitId);
//            userVo.setUnitNameTwo(URLDecoder.decode(request.getHeader("currentUnitName"),"UTF-8"));
            userVo.setUnitId("123");
            userVo.setUnitName("test单位");
            userVo.setUnitIdTwo(currentUnitId);
            userVo.setUnitNameTwo(URLDecoder.decode(request.getHeader("currentUnitName"),"UTF-8"));
        } else {// 如果没有切换单位,存当前单位到现单位中
//            userVo.setUnitId("11330100002489006R");
//            userVo.setUnitName("市本级保密局");
//            userVo.setUnitIdTwo("11330100002489006R");
//            userVo.setUnitNameTwo("市本级保密局");
            userVo.setUnitId("123");
            userVo.setUnitName("test单位");
            userVo.setUnitIdTwo("123");
            userVo.setUnitNameTwo("test单位");
        }
        userVo.setClassification(1);
        MyThreadLocal.set(userVo);
        return true;
    }

    /**
     * 请求处理后
     *
     * @param request  请求头
     * @param response 响应
     * @param handler  适配器
     * @param ex       异常
     */
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        // 请求完后，需要清空 MyThreadLocal 集合数据
        // 避免 OOM
        MyThreadLocal.remove();
        log.info("-----afterCompletion----MyThreadLocal.remove()");
    }

    public void response(HttpServletResponse response, String message, Integer status) throws IOException {
        response.setHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "Content-Type, Content-Length, Authorization, Accept, X-Requested-With , yourHeaderFeild");
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE);
        response.setStatus(status);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        Map<String, Object> result = new HashMap<>(2);
        result.put("message", message);
        servletOutputStream.write(new ObjectMapper().writeValueAsString(result).getBytes(StandardCharsets.UTF_8));
        servletOutputStream.flush();
        servletOutputStream.close();
    }
}


