package com.tykj.classified.config.webmvc;

import com.tykj.classified.config.interceptor.BaseInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;


/**
 * @author 邵越
 */
@Slf4j
@Configuration
public class MyWebMvcConfig implements WebMvcConfigurer {

    @Autowired
    private BaseInterceptor baseInterceptor;

    @Value("${file.upload.path}")
    private String path;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
//        log.info("path:{}",path);
        registry.addResourceHandler("/conf/**")
                .addResourceLocations("file:"+path)
                .addResourceLocations("file:/opt/conf/");
        registry.addResourceHandler("/**")
                .addResourceLocations("Classpath:/static/");
        registry.addResourceHandler("/swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");
        registry.addResourceHandler("/web/**")
                .addResourceLocations("classpath:/web/");
        registry.addResourceHandler("/doc.html")
                .addResourceLocations("classpath:/META-INF/resources/");
        registry.addResourceHandler("/webjars/**")
                .addResourceLocations( "classpath:/META-INF/resources/webjars/");
    }

    /**
     * 针对所有的请求，增加一个获取header数据的解析
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(baseInterceptor).addPathPatterns("/**");
    }
}
