package com.tykj.classified.controller;


import com.tykj.classified.entity.db1.ConfClassifiedAuth;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.PageResult;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
* @author sjq
*/
@Slf4j
@RestController
@RequestMapping("/confClassifiedAuth")
@Api(tags = "dm授权名录相关接口")
public class ConfClassifiedAuthController {

    private final ConfClassifiedAuthService confClassifiedAuthService;

    public ConfClassifiedAuthController(ConfClassifiedAuthService confClassifiedAuthService) {
        this.confClassifiedAuthService = confClassifiedAuthService;
    }

    @ApiOperation(value = "查询当前登录人单位id以及单位")
    @GetMapping("/findLoginUserUnit")
    public ServerResponse<UserInfoVo> findLoginUserUnit() {
        log.info("查询当前登录人单位id以及单位==============================================");
        UserInfoVo userInfoVo = confClassifiedAuthService.findLoginUserUnit();
        return ServerResponse.ok(userInfoVo);
    }

    @ApiOperation(value = "查询dm授权名录-分页(dm授权名录列表分页查询)")
    @PostMapping("/findAllClassifiedAuthPaging")
    public ServerResponse<ConfClassifiedAuthVo> findAllClassifiedAuthPaging(@RequestBody ConfClassifiedAuthPageVo confClassifiedAuthPageVo) {
        log.info("查询dm授权名录-分页(dm授权名录列表分页查询)==============================================");
        log.info("confClassifiedAuthPageVo:{}", confClassifiedAuthPageVo);
        return ServerResponse.ok(confClassifiedAuthService.findAllClassifiedAuthPaging(confClassifiedAuthPageVo));
    }


    @ApiOperation("新增or修改dm授权名录")
    @PostMapping("/addConfClassifiedAuth")
    public ServerResponse<String> addConfClassifiedAuth(@RequestBody ConfClassifiedAuthAddVo confClassifiedAuthAddVo) {
        confClassifiedAuthService.addConfClassifiedAuth(confClassifiedAuthAddVo);
        return ServerResponse.ok("保存成功");
    }

    @ApiOperation("删除dm授权名录")
    @GetMapping("/deleteConfClassifiedAuth/{id}")
    public ServerResponse<String> deleteConfClassifiedAuth(@PathVariable("id") String id) {
        confClassifiedAuthService.deleteConfClassifiedAuth(id);
        return ServerResponse.ok("删除成功");
    }
}
