package com.tykj.classified.controller;

import com.tykj.classified.entity.db1.ConfClassifiedBasisCatalogue;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedBasisCatalogueService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-14 18:25
 */
@Slf4j
@RestController
@RequestMapping("/confClassifiedBasisCatalogue")
@Api(tags = "定密依据目录接口相关文档")
public class ConfClassifiedBasisCatalogueController {

    @Autowired
    private ConfClassifiedBasisCatalogueService confClassifiedBasisCatalogueService;

    @ApiOperation(value = "依据管理-查询定密依据目录")
    @PostMapping("/findAllClassifiedBasisCatalogue")
    public ServerResponse<ConfClassifiedBasisCatalogueShowVo> findAllClassifiedBasisCatalogue(@RequestBody ConfClassifiedBasisCataloguePageVo confClassifiedBasisCataloguePageVo) {
        log.info("查询定密依据目录==============================================");
        ConfClassifiedBasisCatalogueShowVo confClassifiedBasisCatalogueShowVo = confClassifiedBasisCatalogueService.findAllClassifiedBasisCatalogue(confClassifiedBasisCataloguePageVo);
        return ServerResponse.ok(confClassifiedBasisCatalogueShowVo);
    }

    @ApiOperation(value = "依据管理-新增or修改定密依据目录")
    @PostMapping("/addClassifiedBasisCatalogue")
    public ServerResponse<String> addClassifiedBasisCatalogue(@RequestBody ConfClassifiedBasisCatalogueAddVo confClassifiedBasisCatalogueAddVo) {
        log.info("新增定密依据目录==============================================");
        confClassifiedBasisCatalogueService.addClassifiedBasisCatalogue(confClassifiedBasisCatalogueAddVo);
        return ServerResponse.ok("新增成功");
    }

    @ApiOperation(value = "依据管理-删除定密依据目录")
    @GetMapping("/deleteClassifiedBasisCatalogue")
    public ServerResponse<String> deleteClassifiedBasisCatalogue(@RequestParam("catalogueId") String catalogueId) {
        log.info("删除定密依据目录==============================================");
        confClassifiedBasisCatalogueService.deleteClassifiedBasisCatalogue(catalogueId);
        return ServerResponse.ok("删除成功");
    }

    @ApiOperation(value = "依据管理-模糊查询定密依据目录")
    @GetMapping("/findClassifiedBasisCatalogueByName")
    public ServerResponse<FindConfClassifiedBasisCatalogueVo> findClassifiedBasisCatalogueByName() {
        log.info("删除定密依据目录==============================================");
        FindConfClassifiedBasisCatalogueVo findConfClassifiedBasisCatalogueVo = confClassifiedBasisCatalogueService.findClassifiedBasisCatalogueByName();
        return ServerResponse.ok(findConfClassifiedBasisCatalogueVo);
    }
}
