package com.tykj.classified.controller;

import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedBasisService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-08-17 10:44
 */
@Slf4j
@RestController
@RequestMapping("/confClassifiedBasic")
@Api(tags = "定密依据接口相关文档")
public class ConfClassifiedBasisController {

    private final ConfClassifiedBasisService confClassifiedBasisService;

    public ConfClassifiedBasisController(ConfClassifiedBasisService confClassifiedBasisService) {
        this.confClassifiedBasisService = confClassifiedBasisService;
    }

    @ApiOperation(value = "依据管理-查询定密依据")
    @PostMapping("/findAllClassifiedBasicByBasisCatalogueId")
    public ServerResponse<ConfClassifiedBasisVo> findAllClassifiedBasicByBasisCatalogueId(@RequestBody ConfClassifiedBasisPageTwoVo confClassifiedBasisPageTwoVo) {
        log.info("查询定密依据-分页(定密依据列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedBasisService.findAllClassifiedBasicByBasisCatalogueId(confClassifiedBasisPageTwoVo));
    }

    /**
     * title：查询定密依据分页列表
     * action：根据第几页和每页显示条数查询，目前没有其他模糊查询字段，如果有请在ConfClassifiedBasisPageVo里面加模糊查询字段再加查询条件即可
     * @param confClassifiedBasisPageVo 定密依据查询Vo
     * @return ConfClassifiedBasisVo 定密依据Vo
     */
    @ApiOperation(value = "查询定密依据-分页(定密依据列表分页查询)")
    @PostMapping("/findAllClassifiedBasicPaging")
    public ServerResponse<ConfClassifiedBasisVo> findAllClassifiedBasicPaging(@RequestBody ConfClassifiedBasisPageVo confClassifiedBasisPageVo) {
        log.info("查询定密依据-分页(定密依据列表分页查询)==============================================");
        log.info("confClassifiedBasicPageVo:{}", confClassifiedBasisPageVo);
        return ServerResponse.ok(confClassifiedBasisService.findAllClassifiedBasicPaging(confClassifiedBasisPageVo));
    }

    /**
     * title：定密依据保存按钮
     * action：新增定密依据记录，如果有定密依据id那就修改定密依据信息，文件都在properties的file.upload.path路径里
     * @param confClassifiedBasisAddVo 定密依据添加Vo
     * @return String
     */
    @ApiOperation(value = "依据管理-保存定密依据")
    @PostMapping("/addClassifiedBasic")
    public ServerResponse<String> addClassifiedBasic(@RequestBody ConfClassifiedBasisAddVo confClassifiedBasisAddVo) {
        confClassifiedBasisService.addClassifiedBasic(confClassifiedBasisAddVo);
        return ServerResponse.ok("新增成功");
    }

    /**
     * title：点击修改查询定密依据详情
     * action：点修改跳修改页面将定密依据信息查询并返回给前端
     * @param id 定密依据id
     * @return ConfClassifiedBasisAddVo 定密依据添加Vo
     */
    @ApiOperation(value = "依据管理-根据编号查询定密依据详情")
    @GetMapping("/findOneClassifiedBasicById")
    public ServerResponse<ConfClassifiedBasisAddVo> findOneClassifiedBasicById(@RequestParam("id") String id) {

        ConfClassifiedBasisAddVo confClassifiedBasisAddVo =  confClassifiedBasisService.findOneClassifiedBasicById(id);
        return ServerResponse.ok(confClassifiedBasisAddVo);
    }

    /**
     * title：上传定密依据文件
     * action：新增定密依据时上传文件调用此接口
     * @param files 文件数组
     * @return List<FileVo> 文件Vo的list
     */
    @ApiOperation(value = "多文件上传")
    @PostMapping("/filesUpload")
    public ServerResponse<List<FileVo>> filesUpload(@RequestParam("file") MultipartFile[] files) {
        log.info("多文件上传============================================");
        try {
            return ServerResponse.ok(confClassifiedBasisService.filesUpload(files));
        } catch (Exception e) {
            throw new BizException("文件上传失败");
        }
    }

    /**
     * title：删除定密依据
     * action：根据定密依据id删除定密依据
     * @param id 定密依据id
     * @return String
     */
    @ApiOperation(value = "依据管理-删除定密依据")
    @GetMapping("/deleteClassifiedBasis")
    public ServerResponse<String> deleteClassifiedBasis(@RequestParam("id") String id) {
        log.info("删除定密依据===================================================");
        log.info("id:{}",id);
        confClassifiedBasisService.deleteClassifiedBasis(id);
        return ServerResponse.ok("删除成功");
    }

    @ApiOperation(value = "单位的依据配置-查询依据树")
    @GetMapping("/findBasisTree")
    public ServerResponse<List<BasisTreeVo>> findBasisTree(@RequestParam("unitId") String unitId) {
        log.info("查询依据树===================================================");
        List<BasisTreeVo> treeVoList = confClassifiedBasisService.findBasisTree(unitId);
        return ServerResponse.ok(treeVoList);
    }

    @ApiOperation(value = "单位的依据配置-选中依据")
    @PostMapping("/checkBasis")
    public ServerResponse<String> checkBasis(@RequestBody BasisCheckVo basisCheckVo) {
        log.info("选中依据===================================================");
        confClassifiedBasisService.checkBasis(basisCheckVo);
        return ServerResponse.ok("选择成功");
    }
}
