package com.tykj.classified.controller;

import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.classcount.ScreenCountVo;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * dm数据大屏
 *
 * @author 邵越
 * @create 2022/11/18 10:00
 */

@Slf4j
@RestController
@RequestMapping("/confClassifiedCount")
@Api(tags = "dm数据大屏")
public class ConfClassifiedCountController {

    @Autowired
    private ConfClassifiedCountService confClassifiedCountService;

    @Autowired
    private ConfClassifiedPersonLiableService confClassifiedPersonLiableService;

    @Autowired
    private ConfClassifiedAuthService confClassifiedAuthService;

    @Autowired
    private ConfClassifiedService confClassifiedService;

    @Autowired
    private ConfClassifiedSystemService confClassifiedSystemService;

    @Autowired
    private ConfClassifiedTrainingService confClassifiedTrainingService;

    /**
     * 1-缺失定m责任人,2-缺失定m培训,3-缺失定m制度
     */
    @ApiOperation("获取单位节点和单位树")
    @GetMapping("/getUnitTree")
    public ServerResponse<List<ConfUnitNode>> getUnitTree() {
        List<ConfUnitNode> confUnitNodeTree = confClassifiedCountService.getUnitTree();
        return ServerResponse.ok(confUnitNodeTree);
    }

    @ApiOperation("根据节点id查询所有大屏数据")
    @GetMapping("/getAllCount2")
    public ServerResponse<ScreenCountVo> getAllCount2(@RequestParam("nodeId") String nodeId) {
        ScreenCountVo screenCountVo = confClassifiedCountService.getAllCount2(nodeId);
        return ServerResponse.ok(screenCountVo);
    }

    @ApiOperation("根据单位id查询所有大屏数据")
    @GetMapping("/getAllCount")
    public ServerResponse<ScreenCountVo> getAllCount(@RequestParam(value = "unitId",required = false) String unitId) {
        ScreenCountVo screenCountVo = confClassifiedCountService.getAllCount(unitId);
        return ServerResponse.ok(screenCountVo);
    }

    @ApiOperation(value = "大屏查询dm责任人名单-分页(dm责任人名单列表分页查询(节点id))")
    @PostMapping("/findAllClassifiedPersonLiablePagingByDpNodeId")
    public ServerResponse<ConfClassifiedPersonLiableVo> findAllClassifiedPersonLiablePagingByDpNodeId(@RequestBody ConfClassifiedPersonLiablePageTwoVo confClassifiedPersonLiablePageTwoVo) {
        log.info("查询dm责任人名单-分页(dm责任人名单列表分页查询(节点id))==============================================");
        return ServerResponse.ok(confClassifiedPersonLiableService.findAllClassifiedPersonLiablePagingByDpNodeId(confClassifiedPersonLiablePageTwoVo));
    }

    @ApiOperation(value = "大屏查询dm责任人名单-分页(dm责任人名单列表分页查询(单位id))")
    @PostMapping("/findAllClassifiedPersonLiablePagingByDpUnitId")
    public ServerResponse<ConfClassifiedPersonLiableVo> findAllClassifiedPersonLiablePagingByDpUnitId(@RequestBody ConfClassifiedPersonLiablePageThreeVo confClassifiedPersonLiablePageThreeVo) {
        log.info("查询dm责任人名单-分页(dm责任人名单列表分页查询(单位id))==============================================");
        return ServerResponse.ok(confClassifiedPersonLiableService.findAllClassifiedPersonLiablePagingByDpUnitId(confClassifiedPersonLiablePageThreeVo));
    }

    @ApiOperation(value = "查询dm授权名录-分页(dm授权名录列表分页查询(节点id))")
    @PostMapping("/findAllClassifiedAuthPagingByDpNodeId")
    public ServerResponse<ConfClassifiedAuthVo> findAllClassifiedAuthPagingByDpNodeId(@RequestBody ConfClassifiedAuthPageTwoVo confClassifiedAuthPageTwoVo) {
        log.info("查询dm授权名录-分页(dm授权名录列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedAuthService.findAllClassifiedAuthPagingByDpNodeId(confClassifiedAuthPageTwoVo));
    }

    @ApiOperation(value = "查询dm授权名录-分页(dm授权名录列表分页查询(单位id))")
    @PostMapping("/findAllClassifiedAuthPagingByDpUnitId")
    public ServerResponse<ConfClassifiedAuthVo> findAllClassifiedAuthPagingByDpUnitId(@RequestBody ConfClassifiedAuthPageThreeVo confClassifiedAuthPageThreeVo) {
        log.info("查询dm授权名录-分页(dm授权名录列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedAuthService.findAllClassifiedAuthPagingByDpUnitId(confClassifiedAuthPageThreeVo));
    }

    @ApiOperation("查询定密信息-分页(事项列表分页查询(节点id))")
    @PostMapping("/findAllClassifiedPagingByDpNodeId")
    public ServerResponse<ConfClassifiedVo> findAllClassifiedPagingByDpNodeId(@RequestBody ConfClassifiedPageTwoVo confClassifiedPageTwoVo) {
        log.info("查询定密信息-分页(事项列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedService.findAllClassifiedPagingByDpNodeId(confClassifiedPageTwoVo));
    }

    @ApiOperation("查询定密信息-分页(事项列表分页查询(单位id))")
    @PostMapping("/findAllClassifiedPagingByDpUnitId")
    public ServerResponse<ConfClassifiedVo> findAllClassifiedPagingByDpUnitId(@RequestBody ConfClassifiedPageThreeVo confClassifiedPageThreeVo) {
        log.info("查询定密信息-分页(事项列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedService.findAllClassifiedPagingByDpUnitId(confClassifiedPageThreeVo));
    }

    @ApiOperation(value = "查询dm制度-分页(dm制度列表分页查询(节点id))")
    @PostMapping("/findAllClassifiedSystemPagingByDpNodeId")
    public ServerResponse<ConfClassifiedSystemVo> findAllClassifiedSystemPagingByDpNodeId(@RequestBody ConfClassifiedSystemPageTwoVo confClassifiedSystemPageTwoVo) {
        log.info("查询dm制度-分页(dm制度列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedSystemService.findAllClassifiedSystemPagingByDpNodeId(confClassifiedSystemPageTwoVo));
    }

    @ApiOperation(value = "查询dm制度-分页(dm制度列表分页查询(单位id))")
    @PostMapping("/findAllClassifiedSystemPagingByDpUnitId")
    public ServerResponse<ConfClassifiedSystemVo> findAllClassifiedSystemPagingByDpUnitId(@RequestBody ConfClassifiedSystemPageThreeVo confClassifiedSystemPageThreeVo) {
        log.info("查询dm制度-分页(dm制度列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedSystemService.findAllClassifiedSystemPagingByDpUnitId(confClassifiedSystemPageThreeVo));
    }

    @ApiOperation(value = "查询dm培训情况-分页(dm培训情况列表分页查询(节点id))")
    @PostMapping("/findAllClassifiedTrainingPagingByDpNodeId")
    public ServerResponse<ConfClassifiedTrainingVo> findAllClassifiedTrainingPagingByDpNodeId(@RequestBody ConfClassifiedTrainingPageTwoVo confClassifiedTrainingPageTwoVo) {
        log.info("查询dm培训情况-分页(dm培训情况列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedTrainingService.findAllClassifiedTrainingPagingByDpNodeId(confClassifiedTrainingPageTwoVo));
    }

    @ApiOperation(value = "查询dm培训情况-分页(dm培训情况列表分页查询(单位id))")
    @PostMapping("/findAllClassifiedTrainingPagingByDpUnitId")
    public ServerResponse<ConfClassifiedTrainingVo> findAllClassifiedTrainingPagingByDpUnitId(@RequestBody ConfClassifiedTrainingPageThreeVo confClassifiedTrainingPageThreeVo) {
        log.info("查询dm培训情况-分页(dm培训情况列表分页查询)==============================================");
        return ServerResponse.ok(confClassifiedTrainingService.findAllClassifiedTrainingPagingByDpUnitId(confClassifiedTrainingPageThreeVo));
    }

}
