package com.tykj.classified.controller;

import com.tykj.classified.entity.db1.ConfClassifiedDetails;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedDetailsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/confClassifiedDetails")
@Api(tags = "定密详情接口相关文档")
public class ConfClassifiedDetailsController {

    private final ConfClassifiedDetailsService confClassifiedDetailsService;

    public ConfClassifiedDetailsController(ConfClassifiedDetailsService confClassifiedDetailsService) {
        this.confClassifiedDetailsService = confClassifiedDetailsService;
    }

    @ApiOperation("新增")
    @PostMapping
    public ServerResponse<ConfClassifiedDetails> save(@RequestBody ConfClassifiedDetails confClassifiedDetails) {
        ConfClassifiedDetails newconfClassifiedDetails = confClassifiedDetailsService.save(confClassifiedDetails);
        return ServerResponse.ok(newconfClassifiedDetails);
    }
}
