package com.tykj.classified.controller;

import com.tykj.classified.entity.vo.ConfClassifiedPersonLiableAddVo;
import com.tykj.classified.entity.vo.ConfClassifiedPersonLiablePageVo;
import com.tykj.classified.entity.vo.ConfClassifiedPersonLiableVo;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedPersonLiableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/confClassifiedPersonLiable")
@Api(tags = "dm责任人名单相关接口")
public class ConfClassifiedPersonLiableController {

    private final ConfClassifiedPersonLiableService confClassifiedPersonLiableService;

    public ConfClassifiedPersonLiableController(ConfClassifiedPersonLiableService confClassifiedPersonLiableService) {
        this.confClassifiedPersonLiableService = confClassifiedPersonLiableService;
    }

    @ApiOperation(value = "查询dm责任人名单-分页(dm责任人名单列表分页查询)")
    @PostMapping("/findAllClassifiedPersonLiablePaging")
    public ServerResponse<ConfClassifiedPersonLiableVo> findAllClassifiedPersonLiablePaging(@RequestBody ConfClassifiedPersonLiablePageVo confClassifiedPersonLiablePageVo) {
        log.info("查询dm责任人名单-分页(dm责任人名单列表分页查询)==============================================");
        log.info("confClassifiedPersonLiablePageVo:{}", confClassifiedPersonLiablePageVo);
        return ServerResponse.ok(confClassifiedPersonLiableService.findAllClassifiedPersonLiablePaging(confClassifiedPersonLiablePageVo));
    }


    @ApiOperation("新增or修改dm责任人名单")
    @PostMapping("/addConfClassifiedPersonLiable")
    public ServerResponse<String> addConfClassifiedPersonLiable(@RequestBody ConfClassifiedPersonLiableAddVo confClassifiedPersonLiableAddVo) {
        confClassifiedPersonLiableService.addConfClassifiedPersonLiable(confClassifiedPersonLiableAddVo);
        return ServerResponse.ok("保存成功");
    }

    @ApiOperation("删除dm责任人名单")
    @GetMapping("/deleteConfClassifiedPersonLiable/{id}")
    public ServerResponse<String> deleteConfClassifiedPersonLiable(@PathVariable("id") String id) {
        confClassifiedPersonLiableService.deleteConfClassifiedPersonLiable(id);
        return ServerResponse.ok("删除成功");
    }
}
