package com.tykj.classified.controller;


import com.tykj.classified.entity.db1.ConfClassifiedSystem;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/confClassifiedSystem")
@Api(tags = "dm制度相关接口")
public class ConfClassifiedSystemController {

    private final ConfClassifiedSystemService confClassifiedSystemService;

    public ConfClassifiedSystemController(ConfClassifiedSystemService confClassifiedSystemService) {
        this.confClassifiedSystemService = confClassifiedSystemService;
    }

    @ApiOperation(value = "查询dm制度-分页(dm制度列表分页查询)")
    @PostMapping("/findAllClassifiedSystemPaging")
    public ServerResponse<ConfClassifiedSystemVo> findAllClassifiedSystemPaging(@RequestBody ConfClassifiedSystemPageVo confClassifiedSystemPageVo) {
        log.info("查询dm制度-分页(dm制度列表分页查询)==============================================");
        log.info("confClassifiedSystemPageVo:{}", confClassifiedSystemPageVo);
        return ServerResponse.ok(confClassifiedSystemService.findAllClassifiedSystemPaging(confClassifiedSystemPageVo));
    }


    @ApiOperation("新增or修改dm制度")
    @PostMapping("/addConfClassifiedSystem")
    public ServerResponse<String> addConfClassifiedSystem(@RequestBody ConfClassifiedSystemAddVo confClassifiedSystemAddVo) {
        confClassifiedSystemService.addConfClassifiedSystem(confClassifiedSystemAddVo);
        return ServerResponse.ok("保存成功");
    }

    @ApiOperation("删除dm制度")
    @GetMapping("/deleteConfClassifiedSystem/{id}")
    public ServerResponse<String> deleteConfClassifiedSystem(@PathVariable("id") String id) {
        confClassifiedSystemService.deleteConfClassifiedSystem(id);
        return ServerResponse.ok("删除成功");
    }
}
