package com.tykj.classified.controller;


import com.tykj.classified.entity.db1.ConfClassifiedTraining;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedTrainingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
* @author sjq
*/
@Slf4j
@RestController
@RequestMapping("/confClassifiedTraining")
@Api(tags = "dm培训情况相关接口")
public class ConfClassifiedTrainingController {

    private final ConfClassifiedTrainingService confClassifiedTrainingService;

    public ConfClassifiedTrainingController(ConfClassifiedTrainingService confClassifiedTrainingService) {
        this.confClassifiedTrainingService = confClassifiedTrainingService;
    }

    @ApiOperation(value = "查询dm培训情况-分页(dm培训情况列表分页查询)")
    @PostMapping("/findAllClassifiedTrainingPaging")
    public ServerResponse<ConfClassifiedTrainingVo> findAllClassifiedTrainingPaging(@RequestBody ConfClassifiedTrainingPageVo confClassifiedTrainingPageVo) {
        log.info("查询dm培训情况-分页(dm培训情况列表分页查询)==============================================");
        log.info("confClassifiedTrainingPageVo:{}", confClassifiedTrainingPageVo);
        return ServerResponse.ok(confClassifiedTrainingService.findAllClassifiedTrainingPaging(confClassifiedTrainingPageVo));
    }


    @ApiOperation("新增or修改dm培训情况")
    @PostMapping("/addConfClassifiedTraining")
    public ServerResponse<String> addConfClassifiedTraining(@RequestBody ConfClassifiedTrainingAddVo confClassifiedTrainingAddVo) {
        confClassifiedTrainingService.addConfClassifiedTraining(confClassifiedTrainingAddVo);
        return ServerResponse.ok("保存成功");
    }

    @ApiOperation("删除dm培训情况")
    @GetMapping("/deleteConfClassifiedTraining/{id}")
    public ServerResponse<String> deleteConfClassifiedTraining(@PathVariable("id") String id) {
        confClassifiedTrainingService.deleteConfClassifiedTraining(id);
        return ServerResponse.ok("删除成功");
    }
}
