package com.tykj.classified.controller;


import com.tykj.classified.entity.db1.ConfClassifiedUnclearMatters;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfClassifiedUnclearMattersService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/confClassifiedUnclearMatters")
@Api(tags = "不明确事项确定情况相关接口")
public class ConfClassifiedUnclearMattersController {

    private final ConfClassifiedUnclearMattersService confClassifiedUnclearMattersService;

    public ConfClassifiedUnclearMattersController(ConfClassifiedUnclearMattersService confClassifiedUnclearMattersService) {
        this.confClassifiedUnclearMattersService = confClassifiedUnclearMattersService;
    }

    @ApiOperation(value = "查询不明确事项确定情况-分页(不明确事项确定情况列表分页查询)")
    @PostMapping("/findAllClassifiedUnclearMattersPaging")
    public ServerResponse<ConfClassifiedUnclearMattersVo> findAllClassifiedUnclearMattersPaging(@RequestBody ConfClassifiedUnclearMattersPageVo confClassifiedUnclearMattersPageVo) {
        log.info("查询不明确事项确定情况-分页(不明确事项确定情况列表分页查询)==============================================");
        log.info("confClassifiedUnclearMattersPageVo:{}", confClassifiedUnclearMattersPageVo);
        return ServerResponse.ok(confClassifiedUnclearMattersService.findAllClassifiedUnclearMattersPaging(confClassifiedUnclearMattersPageVo));
    }


    @ApiOperation("新增or修改不明确事项确定情况列表")
    @PostMapping("/addConfClassifiedUnclearMatters")
    public ServerResponse<String> addConfClassifiedUnclearMatters(@RequestBody ConfClassifiedUnclearMattersAddVo confClassifiedUnclearMattersAddVo) {
        confClassifiedUnclearMattersService.addConfClassifiedUnclearMatters(confClassifiedUnclearMattersAddVo);
        return ServerResponse.ok("保存成功");
    }

    @ApiOperation("删除不明确事项确定情况列表")
    @GetMapping("/deleteConfClassifiedUnclearMatters/{id}")
    public ServerResponse<String> deleteConfClassifiedUnclearMatters(@PathVariable("id") String id) {
        confClassifiedUnclearMattersService.deleteConfClassifiedUnclearMatters(id);
        return ServerResponse.ok("删除成功");
    }
}
