package com.tykj.classified.controller;

import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/confManage")
@Api(tags = "配置接口相关文档")
public class ConfManageController {

    private final ConfManageService confManageService;

    public ConfManageController(ConfManageService confManageService) {
        this.confManageService = confManageService;
    }

    /**
     * title：查询参数分页俩表
     * action：配置项有：密级，采购单位，缓急程度，提醒期限（月），提醒期限（年）按名称查询参数列表
     * @param confManagePageVo 参数配置分页查询Vo
     * @return ConfManageVo 参数配置Vo
     */
    @ApiOperation("查询参数列表-分页")
    @PostMapping("/findManagePaging")
    public ServerResponse<ConfManageVo> findManagePaging(@RequestBody ConfManagePageVo confManagePageVo) {
        return ServerResponse.ok(confManageService.findManagePaging(confManagePageVo));
    }

    /**
     * title：查询参数配置详情
     * action：根据参数id查询参数信息
     * @param manageId 参数id
     * @return ConfManageDetailVo 参数配置详情Vo
     */
    @ApiOperation("查询参数配置详情")
    @GetMapping("/findManageDetail")
    public ServerResponse<ConfManageDetailVo> findManageDetail(@RequestParam("manageId") String manageId) {
        return ServerResponse.ok(confManageService.findManageDetail(manageId));
    }

    /**
     * title：参数配置保存按钮调用接口
     * action：修改参数配置（分主表和子表）
     * @param confManageEditVo 参数配置修改Vo
     * @return String
     */
    @ApiOperation("保存参数配置")
    @PostMapping("/editManage")
    public ServerResponse<String> editManage(@RequestBody ConfManageEditVo confManageEditVo) {
        confManageService.editManage(confManageEditVo);
        return ServerResponse.ok("保存成功");
    }

    @ApiOperation("查询提醒期限")
    @GetMapping("/findRemind")
    public ServerResponse<ConfRemindVo> findRemind() {
        log.info("查询提醒期限============================================================");
        ConfRemindVo confRemindVo = confManageService.findRemind();
        return ServerResponse.ok(confRemindVo);
    }
}
