package com.tykj.classified.controller;

import com.tykj.classified.entity.vo.ConfOperationRecordListVo;
import com.tykj.classified.entity.vo.ConfOperationRecordPageVo;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfOperationRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/confOperationRecord")
@Api(tags = "操作记录接口相关文档")
public class ConfOperationRecordController {

    private final ConfOperationRecordService confOperationRecordService;

    public ConfOperationRecordController(ConfOperationRecordService confOperationRecordService) {
        this.confOperationRecordService = confOperationRecordService;
    }

    /**
     * title:查询操作记录分页列表使用
     * action：在定密详情中的操作记录里面按分页查询
     * @param confOperationRecordPageVo 操作记录分页Vo
     * @return ConfOperationRecordListVo 操作记录分页查询结果Vo
     */
    @ApiOperation("查询操作记录-分页")
    @PostMapping("/findAllOperationRecordPaging")
    public ServerResponse<ConfOperationRecordListVo> findAllOperationRecordPaging(@RequestBody ConfOperationRecordPageVo confOperationRecordPageVo) {
        return ServerResponse.ok(confOperationRecordService.findAllOperationRecordPaging(confOperationRecordPageVo));
    }
}
