package com.tykj.classified.controller;

import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.vo.ConfUnitNodeAddVo;
import com.tykj.classified.entity.vo.UnitInfoVo;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.ConfUnitNodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-14 13:31
 */
@Slf4j
@RestController
@RequestMapping("/confUnitNode")
@Api(tags = "单位节点树相关文档")
public class ConfUnitNodeController {

    @Autowired
    private ConfUnitNodeService confUnitNodeService;

    @ApiOperation(value = "单位和人员设置-获取单位节点树")
    @GetMapping(value = "/getTree")
    public ServerResponse<List<ConfUnitNode>> getTree(){
        List<ConfUnitNode> tree = confUnitNodeService.getTree();
        return ServerResponse.ok(tree);
    }

    @ApiOperation(value = "单位和人员设置-添加或修改单位节点树")
    @PostMapping(value = "/addTree")
    public ServerResponse<String> addTree(@RequestBody ConfUnitNodeAddVo confUnitNodeAddVo){
        confUnitNodeService.addTree(confUnitNodeAddVo);
        return ServerResponse.ok("操作成功");
    }

    @ApiOperation(value = "单位和人员设置-获取单位属地,单位类型以及管理单位", notes = "获取单位属地,单位类型以及管理单位")
    @GetMapping(value = "/getUnitTerritoryAndUnitType")
    public ServerResponse<UnitInfoVo> getUnitTerritoryAndUnitType(@RequestParam("chooseType") Integer chooseType){
        UnitInfoVo unitInfoVo = confUnitNodeService.getUnitTerritoryAndUnitType(chooseType);
        return ServerResponse.ok(unitInfoVo);
    }

    @ApiOperation(value = "单位和人员设置-删除节点(传节点id,是否单位节点,单位属地id,单位类型)")
    @PostMapping(value = "/deleteTree")
    public ServerResponse<String> deleteTree(@RequestBody ConfUnitNodeAddVo confUnitNodeAddVo){
        confUnitNodeService.deleteTree(confUnitNodeAddVo);
        return ServerResponse.ok("删除成功");
    }

}
