package com.tykj.classified.controller;

import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.db1.DataUnit;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.DataUnitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-14 15:59
 */
@Slf4j
@RestController
@RequestMapping("/dataUnit")
@Api(tags = "单位相关文档")
public class DataUnitController {

    @Autowired
    private DataUnitService dataUnitService;

    @ApiOperation(value = "单位和人员设置-查询单位信息")
    @PostMapping("/findAllUnit")
    public ServerResponse<DataUnitShowVo> findAllUnit(@RequestBody DataUnitPageVo dataUnitPageVo) {
        DataUnitShowVo dataUnitShowVo = dataUnitService.findAllUnit(dataUnitPageVo);
        return ServerResponse.ok(dataUnitShowVo);
    }

    @ApiOperation(value = "单位和人员设置-新增or修改单位信息")
    @PostMapping("/addUnit")
    public ServerResponse<String> addUnit(@RequestBody DataUnitAddVo dataUnitAddVo) {
        dataUnitService.addUnit(dataUnitAddVo);
        return ServerResponse.ok("操作成功");
    }

    @ApiOperation(value = "单位和人员设置-设置委托(委托单位)")
    @PostMapping("/clientUnit")
    public ServerResponse<String> clientUnit(@RequestBody DataUnitClientVo dataUnitClientVo) {
        dataUnitService.clientUnit(dataUnitClientVo);
        return ServerResponse.ok("委托成功");
    }

    @ApiOperation(value = "单位和人员设置-查询委托单位")
    @PostMapping("/findClientUnit")
    public ServerResponse<UnitClientVo> findClientUnit(@RequestBody ClientVo clientVo) {
        UnitClientVo unitClientVo = dataUnitService.findClientUnit(clientVo);
        return ServerResponse.ok(unitClientVo);
    }

    @ApiOperation(value = "单位的依据配置-查询单位节点单位树")
    @GetMapping("/findDataUnitTree")
    public ServerResponse<List<ConfUnitNode>> findDataUnitTree() {
        List<ConfUnitNode> confUnitNodeTree = dataUnitService.findDataUnitTree();
        return ServerResponse.ok(confUnitNodeTree);
    }

    @ApiOperation(value = "全局配置-查询出所有可以管理的单位")
    @GetMapping("/findAllManagementUnit")
    public ServerResponse<List<DataUnit>> findAllManagementUnit() {
        List<DataUnit> dataUnitList = dataUnitService.findAllManagementUnit();
        return ServerResponse.ok(dataUnitList);
    }
}