package com.tykj.classified.controller;

import com.tykj.classified.entity.db1.Employee;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.EmployeeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author sjq
 */
@Slf4j
@RestController
@RequestMapping("/employee")
@Api(tags = "人员接口相关文档")
public class EmployeeController {

    private final EmployeeService employeeService;

    public EmployeeController(EmployeeService employeeService) {
        this.employeeService = employeeService;
    }

    /**
     * title：同步人员接口
     * action：调用第二个数据源的人员信息保存到数据库中
     * @return String
     */
    @ApiOperation(value = "同步人员", notes = "同步人员")
    @GetMapping(value = "/syncPerson")
    public ServerResponse<String> syncPerson(){
        return employeeService.syncPerson();
    }

    /**
     * title：查询人员分页列表
     * action： 根据姓名模糊查询人员信息
     * @param employeePageVo 人员分页查询Vo
     * @return EmployeeVo 人员Vo
     */
    @ApiOperation(value = "查询人员信息-分页")
    @PostMapping("/findAllEmployeePaging")
    public ServerResponse<EmployeeVo> findAllEmployeePaging(@RequestBody EmployeePageVo employeePageVo) {
        return ServerResponse.ok(employeeService.findAllEmployeePaging(employeePageVo));
    }

    /**
     * title：根据人员id查询人员信息详情
     * action：查询人员信息详情信息
     * @param employeeId 人员id
     * @return EmployeeEditVo 编辑人员Vo
     */
    @ApiOperation(value = "根据人员id查询人员信息")
    @GetMapping("/findEmployeeByEmployeeId")
    public ServerResponse<EmployeeEditVo> findEmployeeByEmployeeId(@RequestParam("employeeId") String employeeId) {
        return ServerResponse.ok(employeeService.findEmployeeByEmployeeId(employeeId));
    }

    /**
     * title：人员信息保存按钮调用接口
     * action：保存人员信息
     * @param employeeEditVo 编辑人员Vo
     * @return String
     */
    @ApiOperation(value = "(废弃)保存人员信息")
    @PostMapping("/editEmployee")
    public ServerResponse<String> editEmployee(@RequestBody EmployeeEditVo employeeEditVo) {
        employeeService.editEmployee(employeeEditVo);
        return ServerResponse.ok("编辑成功");
    }

    /**
     * title：查询人员下拉框
     * @return String
     */
    @ApiOperation(value = "查询人员下拉框-法定定m责任人")
    @PostMapping("/selectEmployee")
    public ServerResponse<List<Employee>> selectEmployee(@RequestBody EmployeeSelectPageVo employeeSelectPageVo) {
        log.info("查询人员下拉框=======================================================");
        log.info("employeeSelectPageVo:{}",employeeSelectPageVo);
        List<Employee> selectEmployeeVo = employeeService.selectEmployee(employeeSelectPageVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    /**
     * title：查询人员下拉框
     * @return String
     */
    @ApiOperation(value = "查询人员下拉框Two-指定定m责任人")
    @PostMapping("/selectEmployeeTwo")
    public ServerResponse<List<Employee>> selectEmployeeTwo(@RequestBody EmployeeSelectPageVo employeeSelectPageVo) {
        log.info("查询人员下拉框=======================================================");
        log.info("employeeSelectPageVo:{}",employeeSelectPageVo);
        List<Employee> selectEmployeeVo = employeeService.selectEmployeeTwo(employeeSelectPageVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    /**
     * title：查询人员下拉框
     * @return String
     */
    @ApiOperation(value = "查询人员下拉框Three-承办人")
    @PostMapping("/selectEmployeeThree")
    public ServerResponse<List<Employee>> selectEmployeeThree(@RequestBody EmployeeSelectPageVo employeeSelectPageVo) {
        log.info("查询人员下拉框=======================================================");
        log.info("employeeSelectPageVo:{}",employeeSelectPageVo);
        List<Employee> selectEmployeeVo = employeeService.selectEmployeeThree(employeeSelectPageVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    /**
     * title：查询人员下拉框
     * @return String
     */
    @ApiOperation(value = "查询人员下拉框Four-审批人、分管领导、单位保密委员会或保密工作小组、定密责任人、部门列表")
    @PostMapping("/selectEmployeeFour")
    public ServerResponse<List<Employee>> selectEmployeeFour(@RequestBody EmployeeSelectPageVo employeeSelectPageVo) {
        log.info("查询人员下拉框=======================================================");
        log.info("employeeSelectPageVo:{}",employeeSelectPageVo);
        List<Employee> selectEmployeeVo = employeeService.selectEmployeeFour(employeeSelectPageVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    /**
     * title：查询人员下拉框
     * @return String
     */
    @ApiOperation(value = "查询人员下拉框Six-审批人")
    @PostMapping("/selectEmployeeSix")
    public ServerResponse<List<Employee>> selectEmployeeSix(@RequestBody EmployeeSelectPageVo employeeSelectPageVo) {
        log.info("查询人员下拉框=======================================================");
        log.info("employeeSelectPageVo:{}",employeeSelectPageVo);
        List<Employee> selectEmployeeVo = employeeService.selectEmployeeSix(employeeSelectPageVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    /**
     * title：查询人员信息
     * @return String
     */
    @ApiOperation(value = "查询人员信息")
    @PostMapping("/findEmployeeByName")
    public ServerResponse<List<Employee>> findEmployeeByName(@RequestBody EmployeeSelectVo employeeSelectVo) {
        log.info("查询人员信息=======================================================");
        List<Employee> selectEmployeeVo = employeeService.findEmployeeByName(employeeSelectVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    /**
     * title：查询下拉框
     * @return String
     */
    @ApiOperation(value = "查询下拉框人员")
    @PostMapping("/selectEmployeeFive")
    public ServerResponse<List<Employee>> selectEmployeeFive(@RequestBody FindEmployeeVo findEmployeeVo) {
        log.info("查询下拉框人员=======================================================");
        List<Employee> selectEmployeeVo = employeeService.selectEmployeeFive(findEmployeeVo);
        return ServerResponse.ok(selectEmployeeVo);
    }

    @ApiOperation(value = "单位和人员设置-获取单位下的人员信息")
    @PostMapping("/findEmployeeByUnit")
    public ServerResponse<EmployeeShowTwoVo> findEmployeeByUnit(@RequestBody FindEmployeeByUnitVo findEmployeeByUnitVo) {
        log.info("获取单位下的人员信息=======================================================");
        EmployeeShowTwoVo employeeShowTwoVo = employeeService.findEmployeeByUnit(findEmployeeByUnitVo);
        return ServerResponse.ok(employeeShowTwoVo);
    }

    @ApiOperation(value = "单位和人员设置-新增or修改人员")
    @PostMapping("/addEmployee")
    public ServerResponse<String> addEmployee(@RequestBody EmployeeAddVo employeeAddVo) {
        log.info("新增or修改人员=======================================================");
        employeeService.addEmployee(employeeAddVo);
        return ServerResponse.ok("操作成功");
    }

    @ApiOperation(value = "人员列表-选中审批人或责任人")
    @PostMapping("/checkApprover")
    public ServerResponse<String> checkApprover(@RequestBody EmployeeCheckVo employeeCheckVo) {
        log.info("选中审批人=======================================================");
        employeeService.checkApprover(employeeCheckVo);
        return ServerResponse.ok("选中成功");
    }



    @ApiOperation(value = "初始化数据")
    @GetMapping("/initData")
    public ServerResponse<String> initData() {
        log.info("选中审批人=======================================================");
        employeeService.initData();
        return ServerResponse.ok("初始化成功");
    }
}
