package com.tykj.classified.dao.db1;

import com.tykj.classified.entity.db1.ConfClassifiedBasis;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-08-17 10:43
 */
public interface ConfClassifiedBasisDao extends JpaRepository<ConfClassifiedBasis,String>, JpaSpecificationExecutor<ConfClassifiedBasis> {

    List<ConfClassifiedBasis> findAllByOperatorUnit(String operatorUnit);

    List<ConfClassifiedBasis> findAllByOperatorUnitAndSuitableType(String operatorUnit,Integer suitableType);

    List<ConfClassifiedBasis> findAllBySerialNoAndOperatorUnit(String serialNo,String unitId);

    List<ConfClassifiedBasis> findAllBySuitableType(Integer suitableType);

    List<ConfClassifiedBasis> findAllByCatalogueIdAndSerialNo(String catalogueId,String serialNo);

    List<ConfClassifiedBasis> findAllByCatalogueId(String catalogueId);

    void deleteAllByCatalogueId(String catalogueId);
}
