package com.tykj.classified.dao.db1;

import com.tykj.classified.entity.db1.ConfClassifiedDecrypt;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@Repository
public interface ConfClassifiedDecryptDao extends JpaRepository<ConfClassifiedDecrypt,String>, JpaSpecificationExecutor<ConfClassifiedDecrypt> {

    List<ConfClassifiedDecrypt> findAllByClassifiedIdOrderByCreateTimeDesc(String classifiedId);

    ConfClassifiedDecrypt findByClassifiedIdAndDecryptAuditStatus(String classifiedId,int decryptAuditStatus);

    Optional<ConfClassifiedDecrypt> findConfClassifiedDecryptById(String classifiedDecryptId);

    List<ConfClassifiedDecrypt> findAllByDecryptAuditStatusAndDecryptExecutionStatusAndDecryptTime(int decryptAuditStatus, int decryptExecutionStatus, Date date);

    List<ConfClassifiedDecrypt> findAllByClassifiedIdIn(List<String> classifiedIdList);
}
