package com.tykj.classified.dao.db1;

import com.tykj.classified.entity.db1.DataUnit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-10 17:14
 */
@Repository
public interface DataUnitDao extends JpaRepository<DataUnit,String>, JpaSpecificationExecutor<DataUnit> {

    List<DataUnit> findAllByUnitNatureNot(String unitNature);

    List<DataUnit> findAllByUnitAreaAndUnitNature(String unitAreaId,String unitType);

    List<DataUnit> findAllByIsManageNode(Boolean isManageNode);

    List<DataUnit> findAllByUnitId(String unitId);

    List<DataUnit> findAllByUnitIdIn(List<String> unitIdList);

    DataUnit findDataUnitByUnitId(String unitId);

    List<DataUnit> findAllByIsClientAndUnitClientId(Boolean isClient,String unitClientId);

    List<DataUnit> findAllByUnitArea(String unitAreaId);

    List<DataUnit> findAllByUnitAreaAndIsClientAndUnitClientId(String unitAreaId,Boolean isClient,String unitClientId);

    List<DataUnit> findAllByUnitAreaAndUnitNatureAndIsClientAndUnitClientId(String unitAreaId,String unitType,Boolean isClient,String unitClientId);
}
