package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * -实体类
 *
 * @author sy
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified")
@ApiModel(value = "定密表")
public class ConfClassified {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "事项名称")
    private String itemName;

    @ApiModelProperty(value = "秘密类型(1-公开、2-工作秘密、3-国家秘密)")
    private Integer secretType;

    @ApiModelProperty(value = "类型(1-发文拟稿、2-SM采购、3-SM事项、4-工作秘密)")
    private Integer type;

    @ApiModelProperty(value = "密级(1-内部、2-秘密、3-机密、4-绝密)")
    private String classification;

    @ApiModelProperty(value = "密级排序")
    private Integer classificationSortNum;

    @ApiModelProperty(value = "保密期限类型(1-年、2-月、3-日、4-长期、5-解密条件、6-解密时间)")
    private Integer secrecyTermType;

    @ApiModelProperty(value = "保密期限内容")
    private String secrecyTermContent;

//    @ApiModelProperty("解密条件")
//    private String decryptionConditions;

//    @ApiModelProperty("知悉范围")
//    private String knowScope;

//    @ApiModelProperty("文号 1-默认、2-无")
//    private String titanic;
//    @ApiModelProperty("文号内容")
//    private String titanicContent;

    @ApiModelProperty(value = "定密到期时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date classifiedExpire;

    @ApiModelProperty(value = "变更状态(1-待定密,2-保密中,3-部分解密,4-工作秘密,5-已公开,6-变更中,7-解密中,8-公开中)")
    private Integer changeStatus = 1;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人手机号")
    private String undertakerPhone;

    @ApiModelProperty(value = "发文机关")
    private String undertakerUnit;

    @ApiModelProperty(value = "发文机关2")
    private String undertakerUnitTwo;

//    @ApiModelProperty("印数")
//    private Integer printNums;

//    @ApiModelProperty("缓急程度 1-特急、2-加急、3-无需加急")
//    private String prioritiesType;

//    @ApiModelProperty("审批人名称")
//    private String approvalPerson;

//    @ApiModelProperty("审批人部门")
//    private String approvalDept;

//    @ApiModelProperty("意见内容")
//    private String approvalContent;

//    @ApiModelProperty(value = "指定定密责任人单位")
//    private String specifyClassifiedResponsibleUnit;

    @ApiModelProperty(value = "是否变更")
    private String isUpdate;

    @ApiModelProperty(value = "签发日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date issueDate;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    private Date updateTime;

    @ApiModelProperty(value = "操作人id")
    private String operatorId;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;

    @ApiModelProperty(value = "所属单位信用代码名称")
    private String operatorUnitName;
}
