package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-17 10:29
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_basis")
@ApiModel(value = "定M依据表")
public class ConfClassifiedBasis {

    @Id
    @ApiModelProperty(value = "定M依据id")
    private String id;

    @ApiModelProperty("序号")
    private String serialNo;

    @ApiModelProperty(value = "定M依据名称")
    private String basisName;

    @ApiModelProperty(value = "定M依据名称")
    private String basisName2;

    @ApiModelProperty("适用类型 2-工作MM、3-国家MM")
    private Integer suitableType;

    @ApiModelProperty("M级")
    private String classification;

    @ApiModelProperty("M级排序")
    private Integer classificationSortNum;

    @ApiModelProperty(value = "保M期限类型(1-年、2-月、3-日、4-长期、5-自定义)")
    private Integer secrecyTermType;

    @ApiModelProperty(value = "保M期限内容")
    private String secrecyTermContent;

    @ApiModelProperty("知悉范围")
    private String range;

    @ApiModelProperty("备注")
    private String des;

    @ApiModelProperty(value = "定义依据文件")
    private String basisFile;

    @ApiModelProperty(value = "是否上传文件:1.上传,2.没有上传")
    private Integer isUpload = 2;

    @ApiModelProperty(value = "定M依据描述")
    private String basisDes;

    @ApiModelProperty(value = "目录id")
    private String catalogueId;

    @ApiModelProperty(value = "目录名称")
    private String catalogueName;

    @ApiModelProperty(value = "年度")
    private Integer yearly;

    @ApiModelProperty(value = "操作人")
    private String operatorId;

    @ApiModelProperty(value = "操作人名称")
    private String operatorName;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    private Date updateTime;
}
