package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 依据目录表
 *
 * @author zhaolu
 * @create 2022-11-14 18:17
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_basis_catalogue")
@ApiModel(value = "定M依据目录表")
public class ConfClassifiedBasisCatalogue {

    @Id
    @ApiModelProperty(value = "定M依据目录id")
    private String id;

    @ApiModelProperty("目录名称")
    private String catalogueName;

    @ApiModelProperty("是否可删除(0-不可删除,1-可删除)")
    private Integer canDel = 1;

    @ApiModelProperty(value = "操作人id")
    private String operatorId;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(value = "删除标志(0-未删除，1-已删除)")
    private Integer deleteStatus = 0;

}
