package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_change")
@ApiModel(value = "定密变更表")
public class ConfClassifiedChange {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "定密id")
    private String classifiedId;

    @ApiModelProperty(value = "事项名称")
    private String itemName;

    @ApiModelProperty(value = "类型(1-发文拟稿、2-SM采购、3-SM事项、4-工作秘密)")
    private Integer type;

    @ApiModelProperty(value = "承办部门")
    private String undertakerUnit;

    @ApiModelProperty(value = "变更前密级")
    private String beforeClassification;

    @ApiModelProperty(value = "变更前保密期限类型")
    private Integer beforeSecrecyTermType;

    @ApiModelProperty(value = "变更前保密期限内容")
    private String beforeSecrecyTermContent;

    @ApiModelProperty(value = "变更前知悉范围")
    private String beforeRange;

    @ApiModelProperty(value = "变更前定m依据类型(1-选择依据,2-自定义)")
    private Integer beforeClassifiedBasisType;

    @ApiModelProperty(value = "变更前定m依据内容")
    private String beforeClassifiedBasisContent;

    @ApiModelProperty(value = "变更后密级")
    private String afterClassification;

    @ApiModelProperty(value = "变更后保密期限类型")
    private Integer afterSecrecyTermType;

    @ApiModelProperty(value = "变更后保密期限内容")
    private String afterSecrecyTermContent;

    @ApiModelProperty(value = "变更后知悉范围")
    private String afterRange;

    @ApiModelProperty(value = "变更依据类型(1-选择依据,2-自定义)")
    private String changeBasisType;

    @ApiModelProperty(value = "变更依据内容")
    private String changeBasisContent;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人手机号")
    private String undertakerPhone;

    @ApiModelProperty(value = "定密责任人id")
    private String classificationPerson;

    @ApiModelProperty(value = "定密责任人姓名")
    private String classificationPersonName;

    @ApiModelProperty(value = "定密责任人意见")
    private String classificationOpinion;

    @ApiModelProperty(value = "操作人id")
    private String operatorId;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
