package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_decrypt")
@ApiModel(value = "定密解密表")
public class ConfClassifiedDecrypt {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "定密id")
    private String classifiedId;

    @ApiModelProperty(value = "解密类型(1-维持原定密决定,2-变更,3-解密)")
    private Integer decryptType;

    @ApiModelProperty(value = "解密方式(1-解密并公开,2-解密后内部使用,3-部分解密)")
    private Integer decryptMethod;

    @ApiModelProperty(value = "变更前密级")
    private String beforeClassification;

    @ApiModelProperty(value = "变更前保密期限类型")
    private Integer beforeSecrecyTermType;

    @ApiModelProperty(value = "变更前保密期限内容")
    private String beforeSecrecyTermContent;

    @ApiModelProperty(value = "变更前知悉范围")
    private String beforeRange;

    @ApiModelProperty(value = "变更后密级")
    private String afterClassification;

    @ApiModelProperty(value = "变更后密级排序")
    private Integer afterClassificationSortNum;

    @ApiModelProperty(value = "变更后保密期限类型")
    private Integer afterSecrecyTermType;

    @ApiModelProperty(value = "变更后保密期限内容")
    private String afterSecrecyTermContent;

    @ApiModelProperty(value = "变更后知悉范围")
    private String afterRange;

    @ApiModelProperty(value = "解密依据类型")
    private String secrecyTermBasisType;

    @ApiModelProperty(value = "解密依据内容")
    private String secrecyTermBasisContent;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人意见")
    private String undertakerOpinion;

    @ApiModelProperty(value = "定密责任人id")
    private String classifiedPerson;

    @ApiModelProperty(value = "定密责任人姓名")
    private String classifiedPersonName;

    @ApiModelProperty(value = "定密责任人意见")
    private String classifiedPersonOpinion;

    @ApiModelProperty(value = "建议解密时间")
    private Date decryptTime;

    @ApiModelProperty(value = "解密审核状态(0-待审核,1-已审核)")
    private Integer decryptAuditStatus = 0;

    @ApiModelProperty(value = "解密执行状态(0-待执行,1-已执行)")
    private Integer decryptExecutionStatus = 0;

    @ApiModelProperty(value = "操作人id")
    private String operatorId;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
