package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_person_liable")
@ApiModel(value = "dm责任人")
public class ConfClassifiedPersonLiable {


    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "人员id")
    private String personId;

    @ApiModelProperty(value = "姓名")
    private String personName;

    @ApiModelProperty(value = "职务")
    private String post;

    @ApiModelProperty(value = "部门")
    private String unitDepartment;

    @ApiModelProperty(value = "dm权限id (1-内部、2-秘密、3-机密、4-绝密,5-派生定密)")
    private Integer classifiedAuthId;

    @ApiModelProperty(value = "dm权限")
    private String classifiedAuth;

    @ApiModelProperty(value = "dm事项范围")
    private String classifiedMatters;

    @ApiModelProperty(value = "类别 (1-法定、2-指定)")
    private Integer type;

    @ApiModelProperty(value = "确定时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date sureTime;

    @ApiModelProperty(value = "备注")
    private String des;

    @ApiModelProperty(value = "填报单位id")
    private String fillingUnitId;

    @ApiModelProperty(value = "填报单位")
    private String fillingUnit;

    @ApiModelProperty(value = "填报人id")
    private String fillingPersonId;

    @ApiModelProperty(value = "填报人")
    private String fillingPerson;

    @ApiModelProperty(value = "联系方式")
    private String tel;

    @ApiModelProperty(value = "填报时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date fillingTime;

    @ApiModelProperty(value = "年度")
    private Integer year;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty(value = "删除标志(0-未删除，1-已删除)")
    private Integer deleteStatus = 0;
}
