package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-22 17:50
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_public")
@ApiModel(value = "定密公开表")
public class ConfClassifiedPublic {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "定密id")
    private String classifiedId;

    @ApiModelProperty(value = "公开依据类型")
    private String publicBasisType;

    @ApiModelProperty(value = "公开依据内容")
    private String publicBasisContent;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人意见内容")
    private String undertakerOpinionContent;

    @ApiModelProperty(value = "定密责任人id")
    private String classifiedReviewer;

    @ApiModelProperty(value = "定密责任人姓名")
    private String classifiedReviewerName;

    @ApiModelProperty(value = "定密责任人意见内容")
    private String classifiedOpinionContent;

    @ApiModelProperty(value = "建议公开时间")
    private Date publicTime;

    @ApiModelProperty(value = "公开审核状态(0-待审核,1-已审核)")
    private Integer publicAuditStatus;

    @ApiModelProperty(value = "公开执行状态(0-待执行,1-已执行)")
    private Integer publicExecutionStatus;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
}
