package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_system")
@ApiModel(value = "dm制度")
public class ConfClassifiedSystem {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "文件名")
    private String fileName;

    @ApiModelProperty(value = "文号")
    private String documentNo;

    @ApiModelProperty(value = "颁发日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date issueTime;

    @ApiModelProperty(value = "实施日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date implementationTime;

    @ApiModelProperty(value = "备注")
    private String des;

    @ApiModelProperty(value = "填报单位id")
    private String fillingUnitId;

    @ApiModelProperty(value = "填报单位")
    private String fillingUnit;

    @ApiModelProperty(value = "填报人id")
    private String fillingPersonId;

    @ApiModelProperty(value = "填报人")
    private String fillingPerson;

    @ApiModelProperty(value = "联系方式")
    private String tel;

    @ApiModelProperty(value = "填报时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date fillingTime;

    @ApiModelProperty(value = "年度")
    private Integer year;

    @ApiModelProperty(value = "上传文件名称")
    private String uploadFileName;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty(value = "删除标志(0-未删除，1-已删除)")
    private Integer deleteStatus = 0;
}
