package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_classified_training")
@ApiModel(value = "dm培训情况相关接口")
public class ConfClassifiedTraining {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "培训时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date trainingTime;

    @ApiModelProperty(value = "学时")
    private String creditHours;

    @ApiModelProperty(value = "培训人数")
    private Integer trainingPersonNum;

    @ApiModelProperty(value = "培训对象id （1-保密干部、2-dm责任人） ")
    private Integer trainingObjectId;

    @ApiModelProperty(value = "培训对象")
    private String trainingObject;

    @ApiModelProperty(value = "备注")
    private String des;

    @ApiModelProperty(value = "填报单位id")
    private String fillingUnitId;

    @ApiModelProperty(value = "填报单位")
    private String fillingUnit;

    @ApiModelProperty(value = "填报人id")
    private String fillingPersonId;

    @ApiModelProperty(value = "填报人")
    private String fillingPerson;

    @ApiModelProperty(value = "联系方式")
    private String tel;

    @ApiModelProperty(value = "填报时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date fillingTime;

    @ApiModelProperty(value = "年度")
    private Integer year;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty(value = "删除标志(0-未删除，1-已删除)")
    private Integer deleteStatus = 0;
}
