package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_manage")
@ApiModel(value = "配置主表")
public class ConfManage {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "参数配置类型")
    private String manageName;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    private Date updateTime;
}
