package com.tykj.classified.entity.db1;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_operation_record")
@ApiModel(value = "操作记录表")
public class ConfOperationRecord {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "定密id")
    private String classifiedId;

    @ApiModelProperty(value = "操作内容")
    private String operationContent;

    @ApiModelProperty(value = "操作时间")
    private Date operationTime;

    @ApiModelProperty(value = "操作人id")
    private String operatorId;

    @ApiModelProperty(value = "操作人姓名")
    private String operatorName;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;
}
