package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-14 10:13
 */
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "conf_unit_node")
@ApiModel(value = "单位节点树")
public class ConfUnitNode {

    @Id
    @ApiModelProperty(value = "节点id")
    private String id;

    /**
     * 节点名称
     */
    @ApiModelProperty(value = "节点名称")
    private String nodeName;

    /**
     * 父节点ID
     */
    @ApiModelProperty(value = "父节点ID")
    private String parentId;

    /**
     * 节点关系 例如0.1.4.5 这些数字代表的节点的父节点之间的关系
     */
    @Lob
    @ApiModelProperty(value = "节点关系 例如0.1.4.5 这些数字代表的节点的父节点之间的关系")
    private String nodeRelationship;

    /**
     * 节点等级，行政级别，0-国家、1-省（自治区、直辖市）、2-市（地、州）、3-县（区）、4-下级单位、5-直属单位、6-部门、7-小组
     */
    @ApiModelProperty(value = "节点等级(0-单位,1-节点)")
    private String nodeLevel;

    @ApiModelProperty(value = "管理单位id")
    private String unitManagementId;

    @ApiModelProperty(value = "管理单位")
    private String unitManagement;

    @ApiModelProperty(value = "单位类型id")
    private String unitTypeId;

    @ApiModelProperty(value = "单位类型")
    private String unitType;

    @ApiModelProperty(value = "单位属地id")
    private String unitTerritoryId;

    @ApiModelProperty(value = "单位属地")
    private String unitTerritory;

    @ApiModelProperty(value = "是否单位节点(true-是,false-否)")
    private Boolean isUnitNode;

    @ApiModelProperty(value = "是否管理节点(true-是,false-否)")
    private Boolean isManageNode;

    @ApiModelProperty(value = "操作人id")
    private String operatorId;

    @ApiModelProperty(value = "所属单位信用代码")
    private String operatorUnit;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 子节点
     */
    @Transient
    @ApiModelProperty(value = "子节点")
    private List<ConfUnitNode> childNodes;
}
