package com.tykj.classified.entity.db1;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
* -实体类
*
* @author sy
*/
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "employee")
@ApiModel(value = "人员表")
public class Employee {

    @Id
    @ApiModelProperty(value = "id")
    private String personId;

    @ApiModelProperty(value = "姓名")
    private String personName;

    @ApiModelProperty(value = "手机号")
    private String personTel;

    @ApiModelProperty(value = "部门")
    private String unitDepartment;

    @ApiModelProperty(value = "密级")
    private String secretRelateLevel;

    @ApiModelProperty(value = "法定定密责任人(0-否，1-是)")
    private Integer legalClassifiedResponsible;

    @ApiModelProperty(value = "指定定密责任人(0-否，1-是)")
    private Integer specifyClassifiedResponsible;

    @ApiModelProperty(value = "承办人(0-否，1-是)")
    private Integer undertaker;

    @ApiModelProperty(value = "审批人(0-否，1-是)")
    private Integer approver;

    @ApiModelProperty(value = "单位统一社会信用代码")
    private String unitId;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "职务")
    private String officialCpacity;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
