package com.tykj.classified.entity.db1;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 单位依据中间表
 *
 * @author zhaolu
 * @create 2022-11-15 11:22
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "unit_basis")
@ApiModel(value = "单位依据中间表")
public class UnitBasis {

    @Id
    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "单位id")
    private String unitId;

    @ApiModelProperty(value = "依据id")
    private String basisId;

    @ApiModelProperty(value = "选中状态(0-未选中,1-已选中)")
    private Integer isCheck = 0;
}
