package com.tykj.classified.entity.db2;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.time.LocalDateTime;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("地区字典")
public class Region {

    @Id
    @ApiModelProperty("主键")
    protected String id;

    @ApiModelProperty("创建时间")
    @JsonFormat(timezone = "GMT+8",locale = "zh_CN",pattern = "yyyy-MM-dd HH:mm:ss")
    @CreatedDate
    protected LocalDateTime createdTime;

    @ApiModelProperty("修改时间")
    @JsonFormat(timezone = "GMT+8",locale = "zh_CN",pattern = "yyyy-MM-dd HH:mm:ss")
    @LastModifiedDate
    protected LocalDateTime updatedTime;

    @ApiModelProperty("逻辑删除 0为 false 1为 true")
    protected Integer deleted = 0;

    @ApiModelProperty(value = "地区名")
    private String name;

    @ApiModelProperty(value = "等级，1为省，2为市，3为区")
    private Long level;

    @ApiModelProperty(value = "上级Id")
    private String parentId;

}
