package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-16 10:51
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("依据树Vo")
public class BasisTreeVo {

    @ApiModelProperty(value = "目录id或依据id")
    private String basisId;

    @ApiModelProperty(value = "目录名称或依据名称")
    private String basisName;

    @ApiModelProperty(value = "父节点id")
    private String parentId;

    @ApiModelProperty(value = "是否被选中(0-未选中,1-已选中)")
    private Integer isCheck;

    @ApiModelProperty(value = "子节点List")
    private List<BasisTreeVo> basisTreeVos;
}
