package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 新增dm授权名录Vo
 *
 * @author zhaolu
 * @create 2022-11-09 15:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("dm授权名录添加Vo")
public class ConfClassifiedAuthAddVo {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "被授权单位/单位名称")
    private String quiltAuthUnit;

    @ApiModelProperty(value = "权限id (1-内部、2-秘密、3-机密、4-绝密)")
    private Integer authId;

    @ApiModelProperty(value = "权限")
    private String auth;

    @ApiModelProperty(value = "时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date time;

    @ApiModelProperty(value = "期限")
    private Integer term;

    @ApiModelProperty(value = "事项")
    private String matter;

    @ApiModelProperty(value = "备注")
    private String des;
}
