package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-08-17 14:40
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("定密依据添加Vo")
public class ConfClassifiedBasisAddVo {

    @ApiModelProperty(value = "定密依据id")
    private String id;

    @ApiModelProperty(value = "定密依据名称")
    private String basisName;

    @ApiModelProperty("序号")
    private String serialNo;

    @ApiModelProperty("适用类型 2-工作秘密、3-国家秘密")
    private Integer suitableType;

    @ApiModelProperty("密级")
    private String classification;

    @ApiModelProperty(value = "保密期限类型(1-年、2-月、3-日、4-长期)")
    private Integer secrecyTermType;

    @ApiModelProperty(value = "保密期限内容")
    private String secrecyTermContent;

    @ApiModelProperty("知悉范围")
    private String range;

    @ApiModelProperty("备注")
    private String des;

    @ApiModelProperty(value = "定密依据文件")
    private List<FileVo> basisFile;

    @ApiModelProperty(value = "定密依据描述")
    private String basisDes;

    @ApiModelProperty(value = "目录id")
    private String catalogueId;

    @ApiModelProperty(value = "目录名称")
    private String catalogueName;

    @ApiModelProperty(value = "年度")
    private Integer yearly;

}
