package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-25 18:54
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("定密解密预览Vo")
public class ConfClassifiedDecryptPreviewVo {

    @ApiModelProperty(value = "事项名称")
    private String itemName;

    @ApiModelProperty(value = "文号内容")
    private String documentNumContent;

    @ApiModelProperty(value = "变更前密级")
    private String beforeClassification;

    @ApiModelProperty(value = "变更前保密期限类型")
    private Integer beforeSecrecyTermType;

    @ApiModelProperty(value = "变更前保密期限内容")
    private String beforeSecrecyTermContent;

    @ApiModelProperty(value = "变更前知悉范围")
    private String beforeRange;

    @ApiModelProperty(value = "变更后密级")
    private String afterClassification;

    @ApiModelProperty(value = "变更后保密期限类型")
    private Integer afterSecrecyTermType;

    @ApiModelProperty(value = "变更后保密期限内容")
    private String afterSecrecyTermContent;

    @ApiModelProperty(value = "变更后知悉范围")
    private String afterRange;

    @ApiModelProperty(value = "制发日期==签发日期")
    private Date issueDate;

    @ApiModelProperty(value = "(预览)制发日期==签发日期")
    private String toIssueDate;

    @ApiModelProperty(value = "解密类型(1-维持原定密决定,2-变更,3-解密)")
    private Integer decryptType;

    @ApiModelProperty(value = "解密方式(1-解密并公开,2-解密后内部使用,3-部分解密)")
    private Integer decryptMethod;

    @ApiModelProperty(value = "建议解密时间")
    private Date decryptTime;

    @ApiModelProperty(value = "建议解密时间（后端预览使用）")
    private String toDecryptTime;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人意见")
    private String undertakerOpinion;

    @ApiModelProperty(value = "定密责任人id")
    private String classifiedPerson;

    @ApiModelProperty(value = "定密责任人姓名")
    private String classifiedPersonName;

    @ApiModelProperty(value = "定密责任人意见")
    private String classifiedPersonOpinion;
}
