package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-12 9:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("定m事项解mVo")
public class ConfClassifiedDecryptVo {

    @ApiModelProperty(value = "解mid")
    private String id;

    @ApiModelProperty(value = "定mid")
    private String classifiedId;

    @ApiModelProperty(value = "解m类型(1-维持原定m决定,2-变更,3-解m)")
    private Integer decryptType;

    @ApiModelProperty(value = "解m方式(1-解m并公开,2-解m后内部使用,3-部分解m)")
    private Integer decryptMethod;

    @ApiModelProperty(value = "变更前m级")
    private String beforeClassification;

    @ApiModelProperty(value = "变更前保m期限类型(1-年,2-月,3-自定义)")
    private Integer beforeSecrecyTermType;

    @ApiModelProperty(value = "变更前保m期限内容")
    private String beforeSecrecyTermContent;

    @ApiModelProperty(value = "变更前知悉范围")
    private String beforeRange;

    @ApiModelProperty(value = "变更后m级")
    private String afterClassification;

    @ApiModelProperty(value = "变更后保m期限类型(1-年,2-月,3-自定义)")
    private Integer afterSecrecyTermType;

    @ApiModelProperty(value = "变更后保m期限内容")
    private String afterSecrecyTermContent;

    @ApiModelProperty(value = "变更后知悉范围")
    private String afterRange;

    @ApiModelProperty(value = "解m依据类型")
    private String secrecyTermBasisType;

    @ApiModelProperty(value = "解m依据内容")
    private String secrecyTermBasisContent;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人意见")
    private String undertakerOpinion;

    @ApiModelProperty(value = "定m责任人id")
    private String classifiedPerson;

    @ApiModelProperty(value = "定m责任人姓名")
    private String classifiedPersonName;

    @ApiModelProperty(value = "定m责任人意见")
    private String classifiedPersonOpinion;

    @ApiModelProperty(value = "建议解m时间or建议变更时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date decryptTime;

    @ApiModelProperty(value = "解m审核状态(0-待审核,1-已审核)")
    private Integer decryptAuditStatus;

    @ApiModelProperty(value = "解m执行状态(0-待执行,1-已执行)")
    private Integer decryptExecutionStatus;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
}
