package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-11 15:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("定密详情Vo(新增定密使用)")
public class ConfClassifiedDetailsVo {

    @ApiModelProperty(value = "项目种类(1-货物,2-工程,3-服务)")
    private Integer projectType;

    @ApiModelProperty(value = "类别(1-原始,2-派生)")
    private Integer category;

    @ApiModelProperty(value = "知悉范围（主送）")
    private String range;

    @ApiModelProperty(value = "定m依据类型(1-选择依据,2-自定义)")
    private Integer classifiedBasisType;

    @ApiModelProperty(value = "定m依据内容")
    private String classifiedBasisContent;

    @ApiModelProperty(value = "法定定密责任人id")
    private String legalClassifiedResponsible;

    @ApiModelProperty(value = "法定定密责任人姓名")
    private String legalClassifiedResponsibleName;

    @ApiModelProperty(value = "指定定密责任人id")
    private String specifyClassifiedResponsible;

    @ApiModelProperty(value = "指定定密责任人姓名")
    private String specifyClassifiedResponsibleName;

    @ApiModelProperty(value = "指定定密责任人单位")
    private String specifyClassifiedResponsibleUnit;

    @ApiModelProperty(value = "审批人id")
    private String approver;

    @ApiModelProperty(value = "审批人姓名")
    private String approverName;

    @ApiModelProperty(value = "审批人部门名称")
    private String approverUnit;

    @ApiModelProperty(value = "审批人意见内容")
    private String approverOpinionContent;

    @ApiModelProperty(value = "缓急程度")
    private String urgency;

    @ApiModelProperty(value = "印数")
    private Integer printNum;

    @ApiModelProperty(value = "文号类型(1-默认,2-无,3-便签)")
    private Integer documentNumType;

    @ApiModelProperty(value = "文号内容")
    private String documentNumContent;

    @ApiModelProperty(value = "分管领导意见人id")
    private String chargeLeaderReviewer;

    @ApiModelProperty(value = "分管领导意见人姓名")
    private String chargeLeaderReviewerName;

    @ApiModelProperty(value = "分管领导意见内容")
    private String chargeLeaderOpinionContent;

    @ApiModelProperty(value = "单位保密委员会或保密工作小组审核意见人id")
    private String unitReviewer;

    @ApiModelProperty(value = "单位保密委员会或保密工作小组审核意见人姓名")
    private String unitReviewerName;

    @ApiModelProperty(value = "单位保密委员会或保密工作小组审核意见内容")
    private String unitOpinionContent;

    @ApiModelProperty(value = "定密责任意见人id")
    private String classifiedReviewer;

    @ApiModelProperty(value = "定密责任意见人姓名")
    private String classifiedReviewerName;

    @ApiModelProperty(value = "定密责任意见内容")
    private String classifiedOpinionContent;

    @ApiModelProperty(value = "部门审核意见人id")
    private String departReviewer;

    @ApiModelProperty(value = "部门审核意见人姓名")
    private String departReviewerName;

    @ApiModelProperty(value = "部门审核意见内容")
    private String departOpinionContent;

    @ApiModelProperty(value = "审核意见人id")
    private String reviewer;

    @ApiModelProperty(value = "审核意见人姓名")
    private String reviewerName;

    @ApiModelProperty(value = "审核意见内容")
    private String opinionContent;

    @ApiModelProperty(value = "审核意见人2id")
    private String reviewerTwo;

    @ApiModelProperty(value = "审核意见人2姓名")
    private String reviewerTwoName;

    @ApiModelProperty(value = "审核意见内容2")
    private String opinionContentTwo;

    @ApiModelProperty(value = "备注")
    private String des;

    @ApiModelProperty(value = "采购项目名称")
    private String purchaseItemName;

    @ApiModelProperty(value = "采购单位")
    private String purchasingUnit;

    @ApiModelProperty(value = "项目内容")
    private String projectContent;

    @ApiModelProperty(value = "领导意见")
    private String leaderOpinion;

    @ApiModelProperty(value = "报送时间")
    private Date deliveryTime;
}
