package com.tykj.classified.entity.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 定密分页查询Vo
 *
 * @author zhaolu
 * @create 2022-08-11 14:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("定密分页查询Vo")
public class ConfClassifiedPageVo {

    @ApiModelProperty(value = "头部查询：事项名称")
    private String itemName;

    @ApiModelProperty(value = "头部查询：类型")
    private Integer type;

    @ApiModelProperty(value = "头部查询：密级")
    private String classification;

    @ApiModelProperty(value = "头部查询：状态")
    private Integer changeStatus;

    @ApiModelProperty(value = "秘密类型(1-公开、2-工作秘密、3-国家秘密)")
    private Integer secretType;

    @ApiModelProperty(value = "查询类型(1-确定列表，2-变更列表，3-解除列表)")
    private Integer selectType;

    @ApiModelProperty(value = "查询指定时间类型(1-6月内到期，2-2年内到期，3-全部解密事项)")
    private Integer specifiedTimeType;

    @ApiModelProperty(value = "按类型排序(0-升序，1-降序)")
    private Integer isType;

    @ApiModelProperty(value = "按密级排序(0-升序，1-降序)")
    private Integer isClassified;

    @ApiModelProperty(value = "按状态排序(0-升序，1-降序)")
    private Integer isStatus;

    @ApiModelProperty(value = "按保密到期时间排序(为空不排序，0-升序，1-降序)")
    private Integer classifiedTime;

    @ApiModelProperty(value = "按最近更新时间排序(为空不排序，0-升序，1-降序)")
    private Integer updateTime;

    @ApiModelProperty(value = "解除期限（月）")
    private String month;

    @ApiModelProperty(value = "解除期限（年）")
    private String year;

    @ApiModelProperty(value = "当前页")
    private Integer currentPage;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize;
}
