package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-11-09 16:47
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("dm责任人名单添加Vo")
public class ConfClassifiedPersonLiableAddVo {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "人员id")
    private String personId;

    @ApiModelProperty(value = "人员姓名")
    private String personName;

    @ApiModelProperty(value = "职务")
    private String post;

    @ApiModelProperty(value = "部门")
    private String unitDepartment;

    @ApiModelProperty(value = "dm权限id (1-内部、2-秘密、3-机密、4-绝密)")
    private Integer classifiedAuthId;

    @ApiModelProperty(value = "dm权限")
    private String classifiedAuth;

    @ApiModelProperty(value = "dm事项范围")
    private String classifiedMatters;

    @ApiModelProperty(value = "类别 (1-法定、2-指定)")
    private Integer type;

    @ApiModelProperty(value = "确定时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date sureTime;

    @ApiModelProperty(value = "备注")
    private String des;
}
