package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-22 18:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("定密公开Vo")
public class ConfClassifiedPublicVo {

    @ApiModelProperty(value = "定密公开id")
    private String id;

    @ApiModelProperty(value = "定密id")
    private String classifiedId;

    @ApiModelProperty(value = "公开依据类型")
    private String publicBasisType;

    @ApiModelProperty(value = "公开依据内容")
    private String publicBasisContent;

    @ApiModelProperty(value = "承办人id")
    private String undertaker;

    @ApiModelProperty(value = "承办人姓名")
    private String undertakerName;

    @ApiModelProperty(value = "承办人意见内容")
    private String undertakerOpinionContent;

    @ApiModelProperty(value = "定密责任人id")
    private String classifiedReviewer;

    @ApiModelProperty(value = "定密责任人姓名")
    private String classifiedReviewerName;

    @ApiModelProperty(value = "定密责任人意见内容")
    private String classifiedOpinionContent;

    @ApiModelProperty(value = "建议公开时间")
    private Date publicTime;
}
