package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-11-09 16:49
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("dm制度添加Vo")
public class ConfClassifiedSystemAddVo {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "文件名")
    private String fileName;

    @ApiModelProperty(value = "文号")
    private String documentNo;

    @ApiModelProperty(value = "颁发日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date issueTime;

    @ApiModelProperty(value = "实施日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date implementationTime;

    @ApiModelProperty(value = "备注")
    private String des;
}
